use "${tmp}/main_labex_with_ctrf", clear
	qui tab note_r, gen(e_)
	reghdfe accept e_4-e_7 e_9-e_14 if inrange(note_r, 25, 35)  , noabsorb 
	gdistinct labexid if e(sample)
	regsave using "${tmp}/tmp", replace
	use "${tmp}/tmp", clear
		keep if substr(var , 1, 2) == "e_"
		split var, p(_)
		destring var2, replace
		drop var var1
		set obs 11
		
		replace coef = 0 if coef == . 
		gen grade = var2 - 4 + 25
		replace grade = 29 if grade == .		
		gen label = "Grade = "+string(grade)
		labmask grade, values(label)
		gen ub = coef+invttail(N,0.025)*stde
		gen lb = coef-invttail(N,0.025)*stde
		replace ub = 0 if ub == .
		replace lb = 0 if lb == .

		twoway (rcap ub lb grade if grade < 30, xlab(25(1)35, valuelabel angle(40) nogrid)) (scatter coef grade  if grade < 30, mlcol(black) mcol(navy) msize(large) yline(0) xline(29.5 30.5)) ///
		(rcap ub lb grade if grade >= 30) (scatter coef grade  if grade >= 30, mlcol(black) mcol(green) msize(large)  ), legend(off) ytitle("") xtitle("") yscale(fextend) xscale(fextend) ylab(, nogrid)
		graph export  "${outpath}/Figure3.pdf", as(pdf) replace
		

